#include <QtGui>

#include "TablePages.h"


RelationPage::RelationPage(QWidget *parent)
: QWidget(parent)
{
	QImage relationIcon(tr("images/tiny_execute.png"));
	selaecIconLabel = new QLabel;
	relationIconLabel = new QLabel;
	selaecIconLabel->setPixmap(QPixmap::fromImage(relationIcon));	
	relationIconLabel->setPixmap(QPixmap::fromImage(relationIcon));
	relationNameLabel = new QLabel(tr("ܷŰ ̸ :"));
	relaitonNameEdit = new QLineEdit(tr("fk_id"));
	selectTableLabel = new QLabel(tr("̺/"));
	relationTableLabel = new QLabel(tr(" ̺/"));
	selectTable = new  QComboBox();
	relationTables = new  QComboBox();
	selectField = new  QComboBox();
	relationField = new  QComboBox();
	integrity = new  QCheckBox(tr("׻  Ἲ (&E)"));
	allFieldUpdata = new  QCheckBox(tr(" ʵ  Ʈ(&U)"));
	//recoredDelete = new  QCheckBox(tr(" ڵ  (&D)"));
	
	connect(relationTables, SIGNAL(toggled(bool)), this, SLOT(ClickedCheck()));
	connect(integrity, SIGNAL(toggled(bool)), this, SLOT(ClickedCheck()));
	connect(allFieldUpdata, SIGNAL(toggled(bool)), this, SLOT(ClickedCheck()));
	//connect(recoredDelete, SIGNAL(toggled(bool)), this, SLOT(ClickedCheck()));

	relationNameLabel->setFixedSize(80,30);
	relaitonNameEdit->setFixedSize(150,30);
	selectTable->setFixedSize(200,30);
	relationTables->setFixedSize(200,30);
	selectField->setFixedSize(200,30);
	relationField->setFixedSize(200,30);

	QGridLayout *RelaitonLineLayout = new QGridLayout;
    RelaitonLineLayout->addWidget(relationNameLabel,0,1);
	RelaitonLineLayout->addWidget(relaitonNameEdit,0,2);
	RelaitonLineLayout->setAlignment(Qt::AlignCenter);
	
	QGridLayout *ForiegnLayout = new QGridLayout;
	ForiegnLayout->addWidget(selaecIconLabel,0,0);
	ForiegnLayout->addWidget(selectTableLabel,0,1);
	ForiegnLayout->addWidget(selectTable,1,1);
	ForiegnLayout->addWidget(selectField,2,1);
	ForiegnLayout->addWidget(relationIconLabel,0,2);
	ForiegnLayout->addWidget(relationTableLabel,0,3);
	ForiegnLayout->addWidget(relationTables,1,3);
	ForiegnLayout->addWidget(relationField,2,3);
	ForiegnLayout->setAlignment(Qt::AlignCenter);

	QVBoxLayout *RFLayout = new QVBoxLayout;
	RFLayout->addLayout(RelaitonLineLayout);
	RFLayout->addLayout(ForiegnLayout);

	QVBoxLayout *ConstLayout = new QVBoxLayout;
	ConstLayout->addWidget(integrity);
	ConstLayout->addWidget(allFieldUpdata);

	QGroupBox *relationGroupBox = new QGroupBox(tr("Relation"));
	relationGroupBox->setLayout(RFLayout);
	QGroupBox *constGroupBox = new QGroupBox(tr("Constraint"));
	constGroupBox->setLayout(ConstLayout);

	QVBoxLayout *MainLayout = new QVBoxLayout;
	MainLayout->addWidget(relationGroupBox);
	MainLayout->addSpacing(15);
    MainLayout->addWidget(constGroupBox);
	MainLayout->addSpacing(10);
	setLayout(MainLayout);
}

void RelationPage::AddComboBoxData(int index, const QString &newdata,  int mode)
{
	// mode 0  selectComboBox , mode 1  relaitonTables 
	// mode 2  selectField , mode 3  realtionTables  
	if(mode == 0)
	{
		if(selectTable->itemText(index)!= tr(" "))
			selectTable->removeItem(index);
		
		selectTable->insertItem(index, QIcon(QPixmap("Images/Table.png")), newdata);
	}
	else if(mode == 1)
	{
		if(relationTables->itemText(index)!= tr(" "))
			relationTables->removeItem(index);
		
		relationTables->insertItem(index, QIcon(QPixmap("Images/Table.png")), newdata);
	}
	else if(mode == 2)
	{
		if(selectField->itemText(index)!= tr(" "))
			selectField->removeItem(index);
		
		selectField->insertItem(index, QIcon(QPixmap("Images/column.png")), newdata);
	}
	else
	{
		if(relationField->itemText(index)!= tr(" "))
			relationField->removeItem(index);
		
		relationField->insertItem(index, QIcon(QPixmap("Images/column.png")), newdata);
	}
}

void RelationPage::AddComboBoxData(const QString &newdata,  int mode)
{
	// mode 0  selectComboBox , mode 1  relaitonTables 
	// mode 2  selectField , mode 3  realtionTables  
	if(mode == 0)
	{
		selectTable->addItem(QIcon(QPixmap("Images/Table.png")), newdata);
	}
	else if(mode == 1)
	{
		relationTables->addItem(QIcon(QPixmap("Images/Table.png")), newdata);
	}
	else if(mode == 2)
	{
		selectField->addItem(QIcon(QPixmap("Images/column.png")), newdata);
	}
	else
	{
		relationField->addItem(QIcon(QPixmap("Images/column.png")), newdata);
	}
}

void RelationPage::RemoveComboBoxData(int index,  int mode)
{
	// mode 0  selectComboBox , mode 1  relaitonTables 
	// mode 2  selectField , mode 3  realtionTables  
	if(mode == 0)		
		selectTable->removeItem(index);
	
	else if(mode == 1)
		relationTables->removeItem(index);
	
	else if(mode == 2)
		selectField->removeItem(index);
	
	else
		relationField->removeItem(index);
}

void RelationPage::RemoveComboBoxAllData(int mode)
{
	// mode 0  selectComboBox , mode 1  relaitonTables 
	// mode 2  selectField , mode 3  realtionTables  
	if(mode == 0)		
		selectTable->clear();
	
	else if(mode == 1)
		relationTables->clear();
	
	else if(mode == 2)
		selectField->clear();
	
	else
		relationField->clear();
}

QString RelationPage::CurrentcomboBoxData(int mode)
{
	// mode 0  selectComboBox , mode 1  relaitonTables 
	// mode 2  selectField , mode 3  realtionTables  
	if(mode == 0)
		return selectTable->currentText();
	
	else if(mode == 1)
		return relationTables->currentText();
	
	else if(mode == 2)
		return selectField->currentText();
	
	else
		return relationField->currentText();	
}

bool RelationPage::CurrentCheckBoxState(int mode)
{
	// mode 0  integrity CheckBox , mode 1  allFieldUpdata CheckBox 
	if(mode == 0){
		if( integrity->checkState() == 0 ){
			return false;
		}
		else{
			return true;
		}
	}
	
	else{
		if( allFieldUpdata->checkState() == 0 ){
			return false;
		}
		else{
			return true;
		}
	}
}

QString RelationPage::foriegnkeyName() const
{
	QString relationLine;
	relationLine.clear();
	relationLine = relaitonNameEdit->text();
	return relationLine;
}

void RelationPage::ChangeComboBoxData(const QString &currentdata,const QString &changedata, int mode)
{	
	int index;
	QString compareText;
	
	if(mode == 0)
	{
		selectTable->setItemText(0,changedata);
	}
	else if(mode == 1)
	{
		
		int itemCount = relationTables->count();
		for(int start = 0;start<itemCount;start++)
		{
			compareText = relationTables->itemText(start);
			
			if(compareText == currentdata)
			{
				relationTables->setItemText(start,changedata);
				return;
			}
		}
	}
	else if(mode == 2)
	{
		selectField->setItemText(index,changedata);
	}
	else
	{
		relationField->setItemText(index,changedata);
	}
}

int RelationPage::ComboBoxDataCount(int mode)
{
	// mode 0  selectComboBox , mode 1  relaitonTables 
	// mode 2  selectField , mode 3  realtionTables  
	if(mode == 0)
	{
		return selectTable->count();
	}
	else if(mode == 1)
	{
		return relationTables->count();
	}
	else if(mode == 2)
	{
		return selectField->count();
	}
	else
	{
		return relationField->count();
	}
}

void RelationPage::ClickedCheck()
{
	
}

NewTablePage::NewTablePage(QWidget *parent)
: QWidget(parent)
{
	rowCurrentCount = 0; 
	firstMakeField = 0;
	createDataType();
	createCheck();
	
	TableProperty = new QTableWidget(1, 7, this);
	
	
	QStringList headerLabels;
	headerLabels <<tr(" ")<< tr("ʵ̸") << tr("Ÿ") << tr("") << tr("Not Null") << tr("Default") << tr("");
	TableProperty->setHorizontalHeaderLabels(headerLabels);
	TableProperty->setColumnWidth( 0 ,25 ); 
	TableProperty->setColumnWidth( 4 ,75 ); 
	TableProperty->setColumnWidth( 6 ,200 ); 
	
	TableProperty->setItem(0, 1, new QTableWidgetItem(tr("")));
	TableProperty->setCellWidget(0,2,TableType);
	TableProperty->setItem(0, 3, new QTableWidgetItem(tr("")));
	TableProperty->setCellWidget(0,4,NotNullCheck);
	TableProperty->setItem(0, 5, new QTableWidgetItem(tr("")));
	TableProperty->setItem(0, 6, new QTableWidgetItem(tr("")));
	
	connect(TableProperty, SIGNAL(cellPressed(int,int)), this, SLOT(createField()));
	//connect(TableProperty, SIGNAL(cellEntered(int,int)), this, SLOT(AddchageData()));
	connect(TableProperty, SIGNAL(itemChanged(QTableWidgetItem *)), this, SLOT(itemClicked()));
	
	
	RelationTab = new QTabWidget;
	//	foriegnRelaiotnPage = new RelationPage;
	//    RelationTab->addTab(foriegnRelaiotnPage, tr("Ӽ "));
	
	//	TableProperty->setFixedHeight(300);
	//	RelationTab->setFixedHeight (200);
	//	RelationTab->setFixedSize ( 700, 200 );
	
	QVBoxLayout *PropertyLayout = new QVBoxLayout;
	PropertyLayout->addWidget(TableProperty);
	
	//	QVBoxLayout *RelationLayout = new QVBoxLayout;
	//	RelationLayout->addWidget(RelationTab);
	
    QVBoxLayout *TableLayout = new QVBoxLayout;
    TableLayout->addLayout(PropertyLayout);
	//	TableLayout->addLayout(RelationLayout);
    setLayout(TableLayout);
	
}

void NewTablePage::createDataType()
{
	TableType = new QComboBox();
	
	TableType->addItem(tr("bigint"));
	TableType->addItem(tr("binary"));
	TableType->addItem(tr("bit"));
	TableType->addItem(tr("blob"));
	TableType->addItem(tr("bool"));
	TableType->addItem(tr("boolean"));
	TableType->addItem(tr("char"));
	TableType->addItem(tr("date"));
	TableType->addItem(tr("datetime"));
	TableType->addItem(tr("decimal"));
	TableType->addItem(tr("double"));
	TableType->addItem(tr("enum"));
	TableType->addItem(tr("float"));
	TableType->addItem(tr("int"));
	TableType->addItem(tr("longblob"));
	TableType->addItem(tr("longtext"));
	TableType->addItem(tr("mediumblob"));
	TableType->addItem(tr("mediumint"));
	TableType->addItem(tr("mediumtext"));
	TableType->addItem(tr("numeric"));
	TableType->addItem(tr("real"));
	TableType->addItem(tr("set"));
	TableType->addItem(tr("smallint"));
	TableType->addItem(tr("text"));
	TableType->addItem(tr("time"));
	TableType->addItem(tr("timestamp"));
	TableType->addItem(tr("tinyblob"));
	TableType->addItem(tr("tinyint"));
	TableType->addItem(tr("tinytext"));
	TableType->addItem(tr("varbinary"));
	TableType->addItem(tr("varchar"));
	TableType->addItem(tr("year"));
	TableType->setMaxVisibleItems(5);
	
	//	connect(TableType, SIGNAL(clicked()), this, SLOT(changeTableType()));
}

void NewTablePage::createCheck()
{
	NotNullCheck = new QCheckBox();
}

void NewTablePage::createField()
{
	
	int currentRow = TableProperty->currentRow();
	int rowCount = TableProperty->rowCount();
	int currentColumn = TableProperty->currentColumn();
	QTableWidgetItem * currentItem = new QTableWidgetItem(); 
	
	primaryItem = new QTableWidgetItem();
    primaryItem->setIcon(QIcon(QPixmap("Images/column_pk.png")));
	
	if(currentColumn == 0)
	{
		currentItem	= TableProperty->takeItem(currentRow,currentColumn);
		
		if(!currentItem)
			TableProperty->setItem(currentRow, 0, primaryItem);		//PrimaryKey ǥ ϴ κ	
		else
			TableProperty->removeCellWidget (currentRow, 0); 
	}
	
	currentItem = TableProperty->currentItem(); 
	
	if(currentColumn != 1)
		return;
	
	int compareRow = currentRow +1;
	if(compareRow == rowCount)
	{		
		for(int cnt=0;cnt<rowCount;cnt++)
		{
			if(TableProperty->item(cnt,1)->text()== tr("") && currentRow != 0)
			{
				//QMessageBox::StandardButton warningMessage;
				//warningMessage = QMessageBox::warning(this, tr("ʵ "),
				//tr("ʵ  Է ̽ϴ.\n"
				//	"ʵ  ԷϿ ֽʽÿ."),QMessageBox::Yes);
				return;
			}
		}
		
		
		createDataType();
		createCheck();
		
		TableProperty->insertRow (compareRow) ;
		int insertRow = compareRow;
		
		TableProperty->setItem(insertRow, 1, new QTableWidgetItem(tr("")));
		TableProperty->setCellWidget(insertRow,2,TableType);
		TableProperty->setItem(insertRow, 3, new QTableWidgetItem(tr("")));
		TableProperty->setCellWidget(insertRow,4,NotNullCheck);
		TableProperty->setItem(insertRow, 5, new QTableWidgetItem(tr("")));
		TableProperty->setItem(insertRow, 6, new QTableWidgetItem(tr("")));
		
	}
}
void NewTablePage::itemClicked()
{
	int currentRow = TableProperty->currentRow();
	int currentColumn = TableProperty->currentColumn();
	int AllRowCount = TableProperty->rowCount ();
	QTableWidgetItem * currentItem = new QTableWidgetItem(); 
	currentItem	= TableProperty->currentItem();
	
	
	
	if(currentRow < 0 ||currentColumn <0)
		return;
	qDebug() <<"AllRowCount:"<<AllRowCount << "currentRow :"<<currentRow << "currentColumn:" <<currentColumn;
	if(currentColumn == 0)
	{	
		((QCheckBox*)(TableProperty->cellWidget(currentRow,4)))->setCheckState(Qt::Checked);
		return;
	}
	
	if(!currentItem || currentItem->text() == tr(""))
		return;
	
	if(currentColumn != 1)
		return;
	
	
	QString	currentText = TableProperty->currentItem()->text();
	
	qDebug() << "currentText:" << currentText;
	
	for(int cnt=0;cnt<AllRowCount;cnt++)
	{
		QString compareText =  TableProperty->item(cnt,1)->text();
		if(currentText == tr(" ") || compareText == tr(" "))
			break;
		
		if(currentRow == cnt)
			continue;
		
		if(currentText == compareText)
		{
			qDebug() << currentRow;
			qDebug() << currentColumn;
			qDebug() << currentText;
			qDebug() << compareText;
			QMessageBox::StandardButton Message;
			Message = QMessageBox::warning(this, tr("̸Է "),
				tr("̹ ϴ ʵ ̸Դϴ.\n"
				"ٸ ̸ ԷϽʽÿ."),QMessageBox::Yes);
			TableProperty->setItem(currentRow,currentColumn,new QTableWidgetItem(tr(""))); 
			return;
		}
	}
}


void NewTablePage::currentTable()
{
	//int currentRow = TableProperty->currentRow();
	//int currentColumn = TableProperty->currentColumn();
	QTableWidgetItem * currentItem = new QTableWidgetItem(); 
	currentItem	= TableProperty->currentItem();
	
	QString	currentText = currentItem->text();
}

void NewTablePage::AddTableData(int row, int column, const QString &newdata)
{
	
	createDataType();
	createCheck();
	
	qDebug() << "Entered";
	
	
	if(column == 0)
	{
		if(newdata == "PRI")
		{
			primaryItem = new QTableWidgetItem();
			primaryItem->setIcon(QIcon(QPixmap("Images/column_pk.png")));
			TableProperty->setItem(row, 0, primaryItem);
		}
	}
	else if(column == 2) 
	{
		for(int inx=0; inx<TableType->count();inx++)
		{
			if(newdata == TableType->itemText(inx)){
				TableProperty->setCellWidget (row,column,TableType);
				TableType->setCurrentIndex(inx);
			}
		}	
	}
	else if(column == 4)
	{
		if(newdata == "NO")
		{			
			TableProperty->setCellWidget (row,column,NotNullCheck);
			NotNullCheck->setTristate(1);
		}
		else
		{	
			TableProperty->setCellWidget (row,column,NotNullCheck);
			NotNullCheck->setTristate(0);
		}
		
	}
	else
	{
		if( column == 1){
			TableProperty->insertRow(row) ;
		}

		TableProperty->setItem ( row, column, new QTableWidgetItem(newdata));
	}
}

void NewTablePage::reSizedTable(int row, int column)
{
	TableProperty-> setColumnCount (column);
	TableProperty-> setRowCount (row);
}

